/*
 * Decompiled with CFR 0.152.
 */
package pse.result;

import org.w3c.dom.Node;
import pse.common.NetworkConfiguration;
import pse.result.CalculatedObject;
import pse.result.IosLog;
import pse.util.general.Utilities;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;

public class WorkProduct
extends CalculatedObject {
    protected String dataType;
    protected IosLog iosLog;
    protected NetworkConfiguration networkConfiguration;
    protected long pkaCheckSum = -1L;
    protected byte[] pkaContents;
    protected int pkaSize = 0;

    public String getElementName() {
        return "work-product";
    }

    public boolean hasChildren() {
        return true;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String string) {
        this.dataType = string;
    }

    public IosLog getIosLog() {
        return this.iosLog;
    }

    public IosLog getOrCreateIosLog() {
        if (this.iosLog == null) {
            this.iosLog = new IosLog();
        }
        return this.iosLog;
    }

    public void setIosLog(IosLog iosLog) {
        this.iosLog = iosLog;
    }

    public NetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public NetworkConfiguration getOrCreateNetworkConfiguration() {
        if (this.networkConfiguration == null) {
            this.networkConfiguration = new NetworkConfiguration();
        }
        return this.networkConfiguration;
    }

    public void setNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.networkConfiguration = networkConfiguration;
    }

    public long getPkaCheckSum() {
        return this.pkaCheckSum;
    }

    public void setPkaCheckSum(long l) {
        this.pkaCheckSum = l;
    }

    public void clearPkaContents() {
        this.pkaContents = null;
    }

    public byte[] getPkaContents() {
        return this.pkaContents;
    }

    public void setPkaContents(byte[] byArray) {
        this.pkaContents = byArray;
        this.pkaSize = byArray.length;
        this.dataType = "hex-encoded-binary";
        this.pkaCheckSum = Utilities.calculateCheckSum(byArray);
    }

    public int getPkaSize() {
        return this.pkaSize;
    }

    public void setPkaSize(int n) {
        this.pkaSize = n;
    }

    protected void addChildren(XmlWriter xmlWriter) {
        super.addChildren(xmlWriter);
        xmlWriter.openElement("pka");
        xmlWriter.startElement("byte-info", "checksum", this.pkaCheckSum, "data-type", this.dataType, "size", this.pkaSize);
        if (this.pkaContents == null) {
            xmlWriter.stopAndCloseElement();
        } else {
            xmlWriter.stopElementInline();
            xmlWriter.addTextInline(Utilities.encodeHex(this.pkaContents));
            xmlWriter.closeElement();
        }
        xmlWriter.closeElement();
        this.addOptionalChild(xmlWriter, this.iosLog);
        this.addOptionalChild(xmlWriter, this.networkConfiguration);
    }

    protected void readChildrenFromMyNode(Node node) {
        super.readChildrenFromMyNode(node);
        Node node2 = XmlUtils.getChild(node, "pka");
        Node node3 = XmlUtils.getChild(node2, "byte-info");
        this.dataType = XmlUtils.getAttribute(node3, "data-type");
        this.pkaSize = XmlUtils.getIntAttribute(node3, "size", 0);
        this.pkaCheckSum = XmlUtils.getLongAttribute(node3, "checksum", -1L);
        String string = XmlUtils.getTransitiveText(node3);
        if (string != null && string.trim().length() > 0) {
            this.setPkaContents(Utilities.decodeHex(string.trim()));
        }
        this.iosLog = (IosLog)this.readOptionalChild(node, new IosLog());
        this.networkConfiguration = (NetworkConfiguration)this.readOptionalChild(node, new NetworkConfiguration());
    }
}

